using System;

namespace Team_Project.Exceptions
{
	/// <summary>
	/// Eccezione generata quando una connessione va in time-out
	/// </summary>
	[Serializable]
	public class TimeOutException:TeamProjectException
	{
		private string operationName;
		private string timedOutCopy;
		/// <summary>
		/// Costruisce un'istanza
		/// </summary>
		/// <param name="operation">Descrizione dell'operazione in time-out</param>
		/// <param name="copy">Copia con la quale non si  conclusa l'operazione</param>
		public TimeOutException(string operation,string copy):base()
		{
			operationName = operation;
			timedOutCopy = copy;
		}

		/// <summary>
		/// Descrizione dell'operazione che  andata in time-out
		/// </summary>
		public string Operation
		{
			get{return operationName;}
		}

		/// <summary>
		/// Nome della copia con la quale non si  riuscito a concludere l'operazione
		/// </summary>
		public string CopyInTimeOut
		{
			get{return timedOutCopy;}
		}
	}
}
